Device Standby is designed to be easily extended, you can use XML patch to let more buildings standbyable.

## Find the target

To be the first, find out the building you want to let it be standbyable.

A standbyable building must have a `CompPowerTrader` component:

```xml
<li Class="CompProperties_Power">
    <compClass>CompPowerTrader</compClass>
    <basePowerConsumption>100</basePowerConsumption>
</li>
```

In game, it usually flickable.

Once you lock on your target, note down the `defName`.

## Create a patch

Here's a patch example:

> New to XML patch? See [here](https://rimworldwiki.com/wiki/Modding_Tutorials/PatchOperations).

```xml
<Operation Class="PatchOperationFindMod">
    <mods>
        <li>...</li>
    </mods>
    <match Class="PatchOperationAdd">
        <xpath>/Defs/ThingDef[defName="..."]/comps</xpath>
        <value>
            <li Class="DS.CompProperties_DeviceStandby">
                <mode>...</mode>
                <invert>default: false</invert>
            </li>
        </value>
    </match>
</Operation>
```

`mode` is a required param. Every standbyable device must have a mode, this decides when it's treated as in working mode or standby mode.

`invert` is optional, if marked as true, then when device is in working mode, it's considered as in standby mode, and vise versa.

Below are all modes available now and the condition of being in working mode.

## Standby mode in Vanilla

### Reservable

Building is currently occupied by pawn.

> Examples: being used as joy (TV), as work table (bench), as hauling target (shelf).

### Comp_IThingHolder

Building has component derive from `IThingHolder`, and is holding something.

> Examples: `CompAtomizer`, `CompThingContainer`, `CompGenepackContainer`

### Building_IThingHolder

Building is derive from `IThingHolder`, and is holding something.

> Examples: `DubsBadHygiene.Building_WashingMachine` in DBH

### Building_Turret

Building is derive from `Building_Turret`, and has a active target.

### Building_MechCharger

Building is derive from `Building_MechCharger`, and is charging mech.

### Building_Storage

Building is derive from `Building_Storage`, and is not empty.

### Building_Bed

Building is derive from `Building_Bed`, and at least one pawn is on it.

> Examples: Any bed-like building, deathrest casket

### Building_PlantGrower

Building is derive from `Building_PlantGrower`, and is not empty.

> Example: Hydroponics basin

### Building_Turret

Building is derive from `Building_Turret`, and have a valid target.

### Building_Enterable

Building is derive from `Building_Enterable`, and is working.

Examples: 

### LinkTo_Building_Bed

Building is linked to others whose class derive from `Building_Bed`, and any of them is working.

Examples: Vitals monitor

### LinkTo_Reservable

Building is linked to others and any of them is reserved.

Examples: Multianalyzer

### LinkTo_Building_Enterable

Building is linked to others whose class derive from `Building_Enterable` and any of them is not empty.

## Standby mode in VFE

### VE_Building_ItemProcessor

Building is derive from `ItemProcessor.Building_ItemProcessor`, and is in working stage.

### VE_Comp_ResourceStorage

Building has component derive from `PipeSystem.CompResourceStorage`, and is not empty.

### VE_Comp_ResourceProcessor

Building has component derive from `PipeSystem.CompResourceProcessor`, and is working.

## Standby mode in Processor Framework

### PF_Comp_Processor

Building has component derive from `ProcessorFramework.CompProcessor`, and is not empty.

----

You can check files in `Patches` to find more examples.

## Conflict

Though very rare, some buildings already have their own customized idle logic, if still adding a standby logic on it, they would overwrite each other and cause weird behavior. In that case, avoid patching on it.

There's no general method to distinguish them from the rest, only some experiences:

- If its `CompProperties_Power` have the field `idlePowerDraw` set, it's highly likely to have idle logic
- If it has suspicious component or thingClass, be aware and inspect the source code
- Simply test in game
